<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */

$settings = apply_filters('labb_image_slider_' . $id . '_settings', $settings);

if ($settings->bulk_upload == 'yes') {

    $image_slides = array();

    $ids = $settings->image_gallery;

    if (empty($ids))
        return;

    foreach ($ids as $id):

        $photo_data = FLBuilderPhoto::get_attachment_data($id);

        $image_slide = array('slide_title' => $photo_data->title, 'slide_image' => $id, 'slide_url' => '', 'heading' => $photo_data->caption, 'subheading' => '', 'button_text' => '', 'button_url' => '');

        $image_slides[] = (object)$image_slide;

    endforeach;
}
else {

    $image_slides = $settings->image_slides;

}

$thumbnail_attr = $button_type = '';

$slider_options = [
    'slide_animation' => $settings->slide_animation,
    'direction' => $settings->direction,
    'slideshow_speed' => absint($settings->slideshow_speed),
    'animation_speed' => absint($settings->animation_speed),
    'randomize' => ('yes' === $settings->randomize),
    'loop' => ('yes' === $settings->loop),
    'slideshow' => ('yes' === $settings->slideshow),
    'control_nav' => ('yes' === $settings->control_nav),
    'direction_nav' => ('yes' === $settings->direction_nav),
    'thumbnail_nav' => ('yes' === $settings->thumbnail_nav),
    'pause_on_hover' => ('yes' === $settings->pause_on_hover),
    'pause_on_action' => ('yes' === $settings->pause_on_action)
];

$output = '<div class="labb-image-slider labb-container labb-caption-' . $settings->caption_style
    . '" data-slider-type="' . $settings->slider_type
    . '" data-settings=\'' . wp_json_encode($slider_options) . '\'>';

if ($settings->slider_type == 'flex'):

    $slider_id = null;

    if ('yes' == $settings->thumbnail_nav):

        $carousel_id = uniqid('labb-carousel-');

        $slider_id = uniqid('labb-slider-');

    endif;

    $slider_output = '<div ' . (!empty($slider_id) ? 'id="' . $slider_id . '"' : '')
        . (!empty($carousel_id) ? 'data-carousel="' . $carousel_id . '"' : '')
        . ' class="labb-flexslider">';

    $slider_output .= '<div class="labb-slides">';

    foreach ($image_slides as $slide):

        if (!is_object($slide))
            continue;

        if (!empty($slide->slide_image) && wp_attachment_is_image($slide->slide_image)) :

            if ('yes' == $settings->thumbnail_nav):

                $thumbnail_src = wp_get_attachment_image_src($slide->slide_image, 'medium');

                if ($thumbnail_src)
                    $thumbnail_attr = 'data-thumb="' . $thumbnail_src[0] . '"';

            endif;

            $slide_output = '<div ' . $thumbnail_attr . ' class="labb-slide">';

            $size = isset($settings->image_size) ? $settings->image_size : 'full';

            $src = wp_get_attachment_image_src($slide->slide_image, $size);

            $photo_data = FLBuilderPhoto::get_attachment_data($slide->slide_image);

            // set params
            $photo_settings = array(
                'align' => 'center',
                'link_type' => '',
                'crop' => $settings->crop,
                'photo' => $photo_data,
                'photo_src' => $src[0],
                'photo_source' => 'library',
            );

            if (!empty($slide->slide_url)) {

                $photo_settings['link_type'] = 'url';

                $photo_settings['link_url'] = $slide->slide_url;

                $photo_settings['link_target'] = $settings->link_target;
            }

            // render image
            $image_html = labb_get_image_html($photo_settings);;

            $slide_output .= apply_filters('labb_image_slider_flexslider_thumbnail_html', $image_html, $slide, $settings);

            if (!empty($slide->heading)):

                $slider_caption = '<div class="labb-caption">';

                $slider_subheading = empty($slide->subheading) ? '' : '<div class="labb-subheading">' . htmlspecialchars_decode($slide->subheading) . '</div>';

                $slider_caption .= apply_filters('labb_image_slider_flexslider_slider_subheading_output', $slider_subheading, $slide, $settings);

                if (!empty($slide->heading)):

                    if (!empty($slide->slide_url)) :

                        $slider_heading = '<' . esc_html($settings->heading_tag) . ' class="labb-heading">';

                        $slider_heading .= '<a href="' . esc_url($slide->slide_url)
                            . '" title="' . $slide->slide_title
                            . '">' . $slide->heading . '</a>';

                        $slider_heading .= '</' . esc_html($settings->heading_tag) . '>';

                    else :

                        $slider_heading = '<' . esc_html($settings->heading_tag) . ' class="labb-heading">' . $slide->heading . '</' . esc_html($settings->heading_tag) . '>';

                    endif;

                    $slider_caption .= apply_filters('labb_image_slider_flexslider_slider_heading_output', $slider_heading, $slide, $settings);

                endif;

                if ($settings->caption_style == 'style1' && (!empty($slide->button_url))) :

                    $color_class = ' labb-' . esc_attr($slide->button_color);

                    if (!empty($slide->button_type))
                        $button_type = ' labb-' . esc_attr($slide->button_type);

                    $rounded = ($slide->rounded == 'yes') ? ' labb-rounded' : '';

                    $slider_button = '<a class="labb-button ' . $color_class . $button_type . $rounded
                        . '" href="' . esc_url($slide->button_url)
                        . '"' . (($slide->new_window == 'yes') ? 'target="_blank"' : '')
                        . '>' . $slide->button_text . '</a>';

                    $slider_caption .= apply_filters('labb_image_slider_flexslider_slider_button_output', $slider_button, $slide, $settings);

                endif;

                $slider_caption .= '</div>';

                $slide_output .= apply_filters('labb_image_slider_flexslider_slider_caption_output', $slider_caption, $slide, $settings);

            endif;

            $slide_output .= '</div>';

            $slider_output .= apply_filters('labb_image_slider_flexslider_slide_output', $slide_output, $slide, $settings);

        endif;

    endforeach;

    $slider_output .= '</div><!-- .labb-slides -->';

    $slider_output .= '</div><!-- .labb-flexslider -->';

    $output .= apply_filters('labb_image_slider_flexslider_output', $slider_output, $slider_id, $settings);

    if (!empty($carousel_id)):

        $thumbnail_slider = '<div id="' . $carousel_id . '" class="labb-thumbnailslider labb-flexslider">';

        $thumbnail_slider .= '<div class="labb-slides">';

        foreach ($image_slides as $slide):

            if (!empty($slide->slide_image) && wp_attachment_is_image($slide->slide_image)) :

                $thumbnail_slide = '<div class="labb-slide">';

                $thumbnail_slide .= wp_get_attachment_image($slide->slide_image, 'medium', false, array('class' => 'labb-image medium', 'alt' => $slide->slide_title));

                $thumbnail_slide .= '</div>';

                $thumbnail_slider .= apply_filters('labb_image_slider_flexslider_thumbnail_carousel_slide_output', $thumbnail_slide, $slide, $settings);

            endif;

        endforeach;

        $thumbnail_slider .= '</div>';

        $thumbnail_slider .= '</div>';

        $output .= apply_filters('labb_image_slider_flexslider_thumbnail_carousel_output', $thumbnail_slider, $carousel_id, $settings);

    endif;

elseif ($settings->slider_type == 'nivo') :

    $nivo_captions = array();

    $slider_output = '<div class="nivoSlider">';

    foreach ($image_slides as $slide):

        $slide_output = '';

        $caption_index = uniqid('labb-nivo-caption-');

        if (!empty($slide->slide_image) && wp_attachment_is_image($slide->slide_image)) :

            $thumbnail_src = wp_get_attachment_image_src($slide->slide_image, 'medium');

            if ($thumbnail_src)
                $thumbnail_src = $thumbnail_src[0];

            if (!empty($slide->slide_url)) :

                $thumbnail_html = '<a href="' . esc_url($slide->slide_url)
                    . '" title="' . $slide->slide_title . '">';

                $thumbnail_html .= wp_get_attachment_image($slide->slide_image, 'full', false, array('class' => 'labb-image full', 'data-thumb' => $thumbnail_src, 'alt' => $slide->slide_title, 'title' => ('#' . $caption_index)));

                $thumbnail_html .= '</a>';

            else :

                $thumbnail_html = wp_get_attachment_image($slide->slide_image, 'full', false, array('class' => 'labb-image full', 'data-thumb' => $thumbnail_src, 'alt' => $slide->slide_title, 'title' => ('#' . $caption_index)));

            endif;

            $slide_output = apply_filters('labb_image_slider_nivoslider_thumbnail_html', $thumbnail_html, $slide, $settings);

            if (!empty($slide->heading)):

                if (!empty($slide->slide_url)) :

                    $nivo_caption = '<div id="' . $caption_index
                        . '" class="nivo-html-caption">'
                        . '<div class="labb-subheading">' . htmlspecialchars_decode($slide->subheading)
                        . '</div>' . '<h3 class="labb-heading">'
                        . '<a href="' . esc_url($slide->slide_url)
                        . '" title="' . $slide->slide_title
                        . '">' . $slide->heading . '</a></h3>'
                        . '</div>';

                else :

                    $nivo_caption = '<div id="' . $caption_index
                        . '" class="nivo-html-caption">'
                        . '<div class="labb-subheading">' . htmlspecialchars_decode($slide->subheading) . '</div>'
                        . '<h3 class="labb-heading">' . $slide->heading . '</h3>'
                        . '</div>';

                endif;

                $nivo_captions[] = apply_filters('labb_image_slider_nivoslider_caption' , $nivo_caption, $slide, $settings);

            endif;

        endif;

        $slider_output .= apply_filters('labb_image_slider_nivoslider_slide_output', $slide_output, $slide, $settings);

    endforeach;

    $slider_output .= '</div>';

    $output .= apply_filters('labb_image_slider_nivoslider_output' , $slider_output, $settings);

    $caption_html = '<div class="labb-caption nivo-html-caption">';

    foreach ($nivo_captions as $nivo_caption):

        $caption_html .= $nivo_caption . "\n";

    endforeach;

    $caption_html .= '</div>';

    $output .= apply_filters('labb_image_slider_nivoslider_captions_output' , $caption_html, $settings);

elseif ($settings->slider_type == 'slick') :

    $slider_output = '<div class="labb-slickslider">';

    foreach ($image_slides as $slide):

        $slide_output = '<div class="labb-slide">';

        if (!empty($slide->slide_image) && wp_attachment_is_image($slide->slide_image)) :

            $size = isset($settings->image_size) ? $settings->image_size : 'full';

            $src = wp_get_attachment_image_src($slide->slide_image, $size);

            $photo_data = FLBuilderPhoto::get_attachment_data($slide->slide_image);

            // set params
            $photo_settings = array(
                'align' => 'center',
                'link_type' => '',
                'crop' => $settings->crop,
                'photo' => $photo_data,
                'photo_src' => $src[0],
                'photo_source' => 'library',
            );

            if (!empty($slide->slide_url)) {

                $photo_settings['link_type'] = 'url';

                $photo_settings['link_url'] = $slide->slide_url;

                $photo_settings['link_target'] = $settings->link_target;
            }

            // render image
            $image_html = labb_get_image_html($photo_settings);;

            $slide_output .= apply_filters('labb_image_slider_slickslider_thumbnail_html', $image_html, $slide, $settings);

            $slider_caption = '<div class="labb-caption">';

            $slider_subheading = empty($slide->subheading) ? '' : '<div class="labb-subheading">' . htmlspecialchars_decode($slide->subheading) . '</div>';

            $slider_caption .= apply_filters('labb_image_slider_slickslider_slider_subheading_output', $slider_subheading, $slide, $settings);

            if (!empty($slide->heading)):

                if (!empty($slide->slide_url)) :

                    $slider_heading = '<' . $settings->heading_tag .' class="labb-heading">';

                    $slider_heading .= '<a href="' . esc_url($slide->slide_url)
                        . '" title="' . $slide->slide_title . '">'
                        . $slide->heading . '</a>';

                    $slider_heading .= '</'. $settings->heading_tag . '>';

                else :

                    $slider_heading = '<'. $settings->heading_tag .' class="labb-heading">' . $slide->heading . '</' . $settings->heading_tag . '>';

                endif;

                $slider_caption .= apply_filters('labb_image_slider_slickslider_slider_heading_output', $slider_heading, $slide, $settings);

            endif;

            if ($settings->caption_style == 'style1' && (!empty($slide->button_url))) :

                $color_class = ' labb-' . esc_attr($slide->button_color);

                if (!empty($slide->button_type))
                    $button_type = ' labb-' . esc_attr($slide->button_type);

                $rounded = ($slide->rounded == 'yes') ? ' labb-rounded' : '';

                $slider_button = '<a class="labb-button ' . $color_class . $button_type . $rounded
                    . '" href="' . esc_url($slide->button_url) . '"'
                    . (($slide->new_window == 'yes') ? 'target="_blank"' : '')
                    . '>' . $slide->button_text . '</a>';

                $slider_caption .= apply_filters('labb_image_slider_slickslider_slider_button_output', $slider_button, $slide, $settings);

            endif;

            $slider_caption .= '</div><!-- .labb-caption -->';

            $slide_output .= apply_filters('labb_image_slider_slickslider_slider_caption_output', $slider_caption, $slide, $settings);

        endif;

        $slide_output .= '</div>';

        $slider_output .= apply_filters('labb_image_slider_slickslider_slide_output', $slide_output, $slide, $settings);

    endforeach;

    $slider_output .= '</div>';

    $output .= apply_filters('labb_image_slider_slickslider_output', $slider_output, $settings);

elseif ($settings->slider_type == 'responsive') :

    $slider_output = '<div class="rslides_container">';

    $slider_output .= '<ul class="rslides labb-slide">';

    foreach ($image_slides as $slide):

        $slide_output = '<li>';

        if (!empty($slide->slide_image) && wp_attachment_is_image($slide->slide_image)) :

            $size = isset($settings->image_size) ? $settings->image_size : 'full';

            $src = wp_get_attachment_image_src($slide->slide_image, $size);

            $photo_data = FLBuilderPhoto::get_attachment_data($slide->slide_image);

            // set params
            $photo_settings = array(
                'align' => 'center',
                'link_type' => '',
                'crop' => $settings->crop,
                'photo' => $photo_data,
                'photo_src' => $src[0],
                'photo_source' => 'library',
            );

            if (!empty($slide->slide_url)) {

                $photo_settings['link_type'] = 'url';

                $photo_settings['link_url'] = $slide->slide_url;

                $photo_settings['link_target'] = $settings->link_target;
            }

            // render image
            $image_html = labb_get_image_html($photo_settings);;

            $slide_output .= apply_filters('labb_image_slider_responsiveslider_thumbnail_html', $image_html, $slide, $settings);

            $slider_caption = '<div class="labb-caption">';

            $slider_subheading = empty($slide->subheading) ? '' : '<div class="labb-subheading">' . htmlspecialchars_decode($slide->subheading) . '</div>';

            $slider_caption .= apply_filters('labb_image_slider_slickslider_slider_subheading_output', $slider_subheading, $slide, $settings);

            if (!empty($slide->heading)):

                if (!empty($slide->slide_url)) :

                    $slider_heading = '<'. $settings->heading_tag . ' class="labb-heading">';

                    $slider_heading .= '<a href="' . esc_url($slide->slide_url)
                        . '" title="' . $slide->slide_title
                        . '">' . $slide->heading . '</a>';

                    $slider_heading .= '</' . $settings->heading_tag . '>';

                else :

                    $slider_heading = '<' . $settings->heading_tag . ' class="labb-heading">' . $slide->heading . '</' . $settings->heading_tag . '>';

                endif;

                $slider_caption .= apply_filters('labb_image_slider_responsiveslider_slider_heading_output', $slider_heading, $slide, $settings);

            endif;

            if ($settings->caption_style == 'style1' && (!empty($slide->button_url))) :

                $color_class = ' labb-' . esc_attr($slide->button_color);

                if (!empty($slide->button_type))
                    $button_type = ' labb-' . esc_attr($slide->button_type);

                $rounded = ($slide->rounded == 'yes') ? ' labb-rounded' : '';


                $slider_button = '<a class="labb-button ' . $color_class . $button_type . $rounded
                    . '" href="' . esc_url($slide->button_url) . '" '
                    . (($slide->new_window == 'yes') ? 'target="_blank"' : '')
                    . '>' . $slide->button_text . '</a>';

                $slider_caption .= apply_filters('labb_image_slider_responsiveslider_slider_button_output', $slider_button, $slide, $settings);

            endif;

            $slider_caption .= '</div>';

            $slide_output .= apply_filters('labb_image_slider_responsiveslider_slider_caption_output', $slider_caption, $slide, $settings);

        endif;

        $slide_output .= '</li>';

        $slider_output .= apply_filters('labb_image_slider_responsiveslider_slide_output', $slide_output, $slide, $settings);

    endforeach;

    $slider_output .= '</ul>';

    $slider_output .= '</div>';

    $output .= apply_filters('labb_image_slider_responsiveslider_output', $slider_output, $settings);

endif;

$output .= '</div>';

echo apply_filters('labb_image_slider_output', $output, $settings);